﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.EmployeeCourseSessionQuizAnswer;

/// <summary>
/// Test Email SMTP Setting
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class EmployeeCourseSessionQuizAnswerController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Test Email SMTP Setting
    /// </summary>
    /// <param name="command"></param>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(EmployeeCourseSessionQuizDto))]
    public async Task<IActionResult> CreateEmployeeCourseSessionQuizAnswer(CreateEmployeeCourseSessionQuizAnswerCommand command)
    {
        var result = await mediator.Send(command);
        return GenerateResponse(result);
    }
}
