﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Module
{
    /// <summary>
    /// Controler For Module
    /// </summary>
    /// <param name="_mediator"></param>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ModuleController(
        IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Get All Modules
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public async Task<IActionResult> GetAllModule()
        {
            var result = await _mediator.Send(new GetAllModuleCommand());
            return GenerateResponse(result);
        }
    }
}
