﻿using System;
using System.Text.Json;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;
using QualityManagement.Repository;

namespace QualityManagement.API.Controllers.NLog;


/// <summary>
/// Controller For NLog
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class NLogController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Get System Logs
    /// </summary>
    /// <param name="nLogResource"></param>
    /// <returns></returns>
    [HttpGet]
    [Produces("application/json", "application/xml", Type = typeof(NLogList))]
    [ClaimCheck("VIEW_ERROR_LOGS")]
    public async Task<IActionResult> GetNLogs([FromQuery] NLogResource nLogResource)
    {
        var getAllLoginAuditQuery = new GetNLogsQuery
        {
            NLogResource = nLogResource
        };
        var result = await _mediator.Send(getAllLoginAuditQuery);

        var paginationMetadata = new
        {
            totalCount = result.TotalCount,
            pageSize = result.PageSize,
            skip = result.Skip,
            totalPages = result.TotalPages
        };
        Response.Headers.Append("X-Pagination",
          JsonSerializer.Serialize(paginationMetadata));
        return Ok(result);
    }

    /// <summary>
    /// Get Log By Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(NLogDto))]
    [ClaimCheck("VIEW_ERROR_LOGS")]
    public async Task<IActionResult> GetNLog(Guid id)
    {
        var getLogQuery = new GetLogQuery { Id = id };
        var result = await _mediator.Send(getLogQuery);
        return GenerateResponse(result);
    }

}

