﻿using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller for NonConformance Log
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class NonConformanceLogController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Get All NonConformances Log
        /// </summary>
        /// <param name="nonConformanceLogResource"></param>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("MANAGE_NON_CONFORMANCE_LOGS")]
        public async Task<IActionResult> GetNonConformances([FromQuery] NonConformanceLogResource nonConformanceLogResource)
        {
            var getNonConformanceLogListCommand = new GetNonConformanceLogListCommand()
            {
                NonConformanceLogResource = nonConformanceLogResource
            };
            var result = await _mediator.Send(getNonConformanceLogListCommand);
            var paginationMetadata = new
            {
                totalCount = result.TotalCount,
                pageSize = result.PageSize,
                skip = result.Skip,
                totalPages = result.TotalPages
            };
            Response.Headers.Append("X-Pagination",
                Newtonsoft.Json.JsonConvert.SerializeObject(paginationMetadata));

            return Ok(result);
        }
    }
}
