﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller for NonConformanceResponseType
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class NonConformanceResponseTypeController(IMediator mediator) : BaseController
    {
        /// <summary>
        /// Create A NonConformanceResponseType 
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_NON_CONFORMANCE_RESPONSE_TYPE")]
        public async Task<IActionResult> CreateNonConformanceResponseType(AddNonConformanceResponseTypeCommand command)
        {
            var result = await mediator.Send(command);
            return GenerateResponse(result);
        }
        /// <summary>
        /// Update A NonConformanceResponseType
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("EDIT_NON_CONFORMANCE_RESPONSE_TYPE")]
        public async Task<IActionResult> UpdateNonConformanceResponseType(Guid id, UpdateNonConformanceResponseTypeCommand command)
        {
            command.Id = id;
            var result = await mediator.Send(command);
            return GenerateResponse(result);
        }
        /// <summary>
        /// Delete NonConformanceResponseType by id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>

        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_NON_CONFORMANCE_RESPONSE_TYPE")]
        public async Task<IActionResult> DeleteNonConformanceResponseType(Guid id)
        {
            var result = await mediator.Send(new DeleteNonConformanceResponseTypeCommand() { Id = id });
            return GenerateResponse(result);
        }
        /// <summary>
        /// Get NonConformanceResponseType by Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        public async Task<IActionResult> GetNonConformanceResponseType(Guid id)
        {
            var result = await mediator.Send(new GetNonConformanceResponseTypeCommand() { Id = id });
            return GenerateResponse(result);
        }
        /// <summary>
        /// Get All NonConformanceResponseType
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("VIEW_NON_CONFORMANCE_RESPONSE_TYPE")]
        public async Task<IActionResult> GetAllNonConformanceResponseType()
        {
            var result = await mediator.Send(new GetAllNonConformanceResponseTypeCommand());
            return GenerateResponse(result);
        }
    }
}
