﻿using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Role;

/// <summary>
/// RoleUsers
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class RoleUsersController(IMediator _mediator, ILogger<RoleUsersController> _logger) : ControllerBase
{
    /// <summary>
    /// Get Role Users By Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpGet("{id}", Name = "RoleUsers")]
    [Produces("application/json", "application/xml", Type = typeof(List<UserRoleDto>))]
    public async Task<IActionResult> RoleUsers(Guid id)
    {
        var getUserQuery = new GetRoleUsersQuery
        {
            RoleId = id
        };
        var result = await _mediator.Send(getUserQuery);
        return Ok(result);
    }
    /// <summary>
    /// Update Role Users By Id
    /// </summary>
    /// <param name="id"></param>
    /// <param name="updateRoleCommand"></param>
    /// <returns></returns>
    [HttpPut("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(UserRoleDto))]
    [ClaimCheck("ASSIGN_USER_ROLE")]
    public async Task<IActionResult> UpdateRoleUsers(Guid id, UpdateUserRoleCommand updateRoleCommand)
    {
        updateRoleCommand.Id = id;
        var result = await _mediator.Send(updateRoleCommand);
        if (result.StatusCode != 200)
        {
            _logger.LogError(result.StatusCode,
                            JsonSerializer.Serialize(result), "");
            return StatusCode(result.StatusCode, result);
        }
        return NoContent();
    }
}
