﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;
/// <summary>
/// Controller for SupplierAudit
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class SupplierAuditController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A SupplierAudit
    /// </summary>
    /// <param name="addSupplierAuditCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(SupplierAuditDto))]
    [ClaimCheck("ADD_SUPPLIER_AUDIT")]
    public async Task<IActionResult> CreateSupplierAudit(AddSupplierAuditCommand addSupplierAuditCommand)
    {
        var result = await mediator.Send(addSupplierAuditCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get SupplierAudit By id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(SupplierAuditDto))]
    [ClaimCheck("VIEW_SUPPLIER_AUDIT")]
    public async Task<IActionResult> GetSupplierAudit(Guid id)
    {
        var getSupplierAuditCommand = new GetSupplierAuditCommand { Id = id };
        var result = await mediator.Send(getSupplierAuditCommand);
        return GenerateResponse(result);
    }
}
