﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;
/// <summary>
/// Controller for SupplierQualification
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class SupplierQualificationController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A SupplierQualification
    /// </summary>
    /// <param name="addSupplierQualificationCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(SupplierQualificationDto))]
    [ClaimCheck("ADD_SUPPLIER_QUALIFICATION")]
    public async Task<IActionResult> CreateSupplierQualification(AddSupplierQualificationCommand addSupplierQualificationCommand)
    {
        var result = await mediator.Send(addSupplierQualificationCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get SupplierQualification By id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(SupplierQualificationDto))]
    [ClaimCheck("VIEW_SUPPLIER_QUALIFICATION")]
    public async Task<IActionResult> GetSupplierQualification(Guid id)
    {
        var getSupplierQualificationCommand = new GetSupplierQualificationCommand { Id = id };
        var result = await mediator.Send(getSupplierQualificationCommand);
        return GenerateResponse(result);
    }
}
