﻿using System;
using System.IO;
using System.IO.Compression;

namespace QualityManagement.Api.Helpers;

/// <summary>
/// CompressUtility is a utility class for compressing and decompressing files using GZip compression.
/// </summary>
public class CompressUtility
{
    /// <summary>
    /// Method to compress files in a specified directory.
    /// </summary>
    /// <param name="directorySelected"></param>
    /// <param name="directoryPath"></param>
    public static void Compress(DirectoryInfo directorySelected, string directoryPath)
    {
        foreach (FileInfo fileToCompress in directorySelected.GetFiles())
        {
            using (FileStream originalFileStream = fileToCompress.OpenRead())
            {
                if ((System.IO.File.GetAttributes(fileToCompress.FullName) &
                   FileAttributes.Hidden) != FileAttributes.Hidden & fileToCompress.Extension != ".gz")
                {
                    string path = directoryPath + fileToCompress.Name + ".gz";
                    using (FileStream compressedFileStream = System.IO.File.Create(path))
                    {
                        using (GZipStream compressionStream = new GZipStream(compressedFileStream,
                           CompressionMode.Compress))
                        {
                            originalFileStream.CopyTo(compressionStream);

                        }
                    }
                }

            }
        }
    }
    /// <summary>
    /// Method to decompress files in a specified directory.
    /// </summary>
    /// <param name="fileToDecompress"></param>
    public static void Decompress(FileInfo fileToDecompress)
    {
        using (FileStream originalFileStream = fileToDecompress.OpenRead())
        {
            string currentFileName = fileToDecompress.FullName;
            string newFileName = currentFileName.Remove(currentFileName.Length - fileToDecompress.Extension.Length);

            using (FileStream decompressedFileStream = System.IO.File.Create(newFileName))
            {
                using (GZipStream decompressionStream = new GZipStream(originalFileStream, CompressionMode.Decompress))
                {
                    decompressionStream.CopyTo(decompressedFileStream);
                    Console.WriteLine($"Decompressed: {fileToDecompress.Name}");
                }
            }
        }
    }
}
