﻿using Amazon.S3;
using Microsoft.Extensions.DependencyInjection;
using QualityManagement.API.Helpers;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Helper;
using QualityManagement.MediatR;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;

namespace QualityManagement.Api.Helpers;
/// <summary>
/// DependencyInjectionExtension is a static class that provides extension methods for configuring dependency injection in the application.
/// </summary>
public static class DependencyInjectionExtension
{
    /// <summary>
    /// Method to add dependency injection for various repositories and services in the application.
    /// </summary>
    /// <param name="services"></param>
    public static void AddDependencyInjection(this IServiceCollection services)
    {
        services.AddScoped(typeof(IUnitOfWork<>), typeof(UnitOfWork<>));
        services.AddScoped<IPropertyMappingService, PropertyMappingService>();
        services.AddScoped<IRoleRepository, RoleRepository>();
        services.AddScoped<IUserRepository, UserRepository>();
        services.AddScoped<IUserRoleRepository, UserRoleRepository>();
        services.AddScoped<IUserClaimRepository, UserClaimRepository>();
        services.AddScoped<IRoleClaimRepository, RoleClaimRepository>();
        services.AddScoped<IDocumentRepository, DocumentRepository>();
        services.AddScoped<ICategoryRepository, CategoryRepository>();
        services.AddScoped<IDocumentShareableLinkRepository, DocumentShareableLinkRepository>();
        services.AddScoped<IDocumentRolePermissionRepository, DocumentRolePermissionRepository>();
        services.AddScoped<IDocumentUserPermissionRepository, DocumentUserPermissionRepository>();
        services.AddScoped<IDocumentAuditTrailRepository, DocumentAuditTrailRepository>();
        services.AddScoped<IUserNotificationRepository, UserNotificationRepository>();
        services.AddScoped<ILoginAuditRepository, LoginAuditRepository>();

        // Reminder
        services.AddScoped<IReminderNotificationRepository, ReminderNotificationRepository>();
        services.AddScoped<IReminderRepository, ReminderRepository>();
        services.AddScoped<IReminderUserRepository, ReminderUserRepository>();
        services.AddScoped<IReminderSchedulerRepository, ReminderSchedulerRepository>();
        services.AddScoped<IDailyReminderRepository, DailyReminderRepository>();
        services.AddScoped<IQuarterlyReminderRepository, QuarterlyReminderRepository>();
        services.AddScoped<IHalfYearlyReminderRepository, HalfYearlyReminderRepository>();
        services.AddScoped<IDocumentTokenRepository, DocumentTokenRepository>();
        services.AddScoped<IEmailSMTPSettingRepository, EmailSMTPSettingRepository>();
        services.AddScoped<ISendEmailRepository, SendEmailRepository>();
        services.AddSingleton<IConnectionMappingRepository, ConnectionMappingRepository>();

        services.AddScoped<IDocumentCommentRepository, DocumentCommentRepository>();

        services.AddScoped<IDocumentVersionRepository, DocumentVersionRepository>();
        services.AddScoped<IDocumentMetaDataRepository, DocumentMetaDataRepository>();

        services.AddScoped<IStorageSettingRepository, StorageSettingRepository>();
        services.AddScoped<IDocumentStatusRepository, DocumentStatusRepository>();
        services.AddScoped<ICompanyProfileRepository, CompanyProfileRepository>();

        //Store stategies dependancies

        services.AddScoped<LocalStorageService>();
        services.AddScoped<AwsS3StorageService>();
        services.AddScoped<CloudflareR2StorageService>();
        services.AddScoped<StorageServiceFactory>();

        services.AddScoped<INLogRepository, NLogRepository>();
        services.AddScoped<IPageHelperRepository, PageHelperRepository>();
        services.AddScoped<IDocumentIndexRepository, DocumentIndexRepository>();

        services.AddScoped<IWorkflowRepository, WorkflowRepository>();
        services.AddScoped<IWorkflowInstanceRepository, WorkflowInstanceRepository>();
        services.AddScoped<IWorkflowStepRepository, WorkflowStepRepository>();
        services.AddScoped<IWorkflowStepInstanceRepository, WorkflowStepInstanceRepository>();
        services.AddScoped<IWorkflowTransitionRepository, WorkflowTransitionRepository>();
        //services.AddScoped<IWorkflowStepRoleRepository, WorkflowStepRoleRepository>();
        services.AddScoped<IWorkflowTransitionInstanceRepository, WorkflowTransitionInstanceRepository>();
        //services.AddScoped<IWorkflowStepUserRepository, WorkflowStepUserRepository>();

        services.AddScoped<IAllowFileExtensionRepository, AllowFileExtensionRepository>();
        services.AddScoped<IWorkflowInstanceEmailSenderRepository, WorkflowInstanceEmailSenderRepository>();
        services.AddScoped<IDocumentSignatureRepository, DocumentSignatureRepository>();
        services.AddScoped<IFileRequestsRepository, FileRequestsRepository>();
        services.AddScoped<IFileRequestDocumentRepository, FileRequestDocumentRepository>();
        services.AddScoped<IClientRepository, ClientRepository>();
        services.AddScoped<IMatTableSettingReposistory, MatTableSettingReposistory>();
        services.AddScoped<IDocumentChunkRepository, DocumentChunkRepository>();
        services.AddScoped<ICategoryRolePermissionRepository, CategoryRolePermissionRepository>();
        services.AddScoped<ICategoryUserPermissionRepository, CategoryUserPermissionRepository>();
        services.AddScoped<IDocumentMetaTagRepository, DocumentMetaTagRepository>();
        services.AddScoped<IUserOpenaiMsgRepository, UserOpenaiMsgRepository>();
        services.AddScoped<IAIPromptTemplateRepository, AIPromptTemplateRepository>();
        services.AddScoped<IWorkflowTransitionRoleRepository, WorkflowTransitionRoleRepository>();
        services.AddScoped<IWorkflowTransitionUserRepository, WorkflowTransitionUserRepository>();
        services.AddScoped<IRecentDocumentRepository, RecentDocumentRepository>();
        // Add AWS S3 configuration
        services.AddAWSService<IAmazonS3>();
        services.AddScoped<EmailHelper>();

        //QualityManagement
        services.AddScoped<IActionRepository, ActionRepository>();
        services.AddScoped<ICourseSessionRepository, CourseSessionRepository>();
        services.AddScoped<ICourseSessionMediaRepository, CourseSessionMediaRepository>();
        services.AddScoped<ICourseSessionMediaChunkRepository, CourseSessionMediaChunkRepository>();
        services.AddScoped<ICourseSessionQuizRepository, CourseSessionQuizRepository>();
        services.AddScoped<ICourseSessionMediaTokenRepository, CourseSessionMediaTokenRepository>();
        services.AddScoped<IQuizQuestionRepository, QuizQuestionRepository>();
        services.AddScoped<IQuizQuestionOptionRepository, QuizQuestionOptionRepository>();
        services.AddScoped<ICourseRepository, CourseRepository>();
        services.AddScoped<IEmailTemplateRepository, EmailTemplateRepository>();

        services.AddScoped<IEmployeeCourseSessionRepository, EmployeeCourseSessionRepository>();
        services.AddScoped<IEmployeeCourseSessionQuizRepository, EmployeeCourseSessionQuizRepository>();
        services.AddScoped<IEmployeeCourseSessionQuizAnswerRepository, EmployeeCourseSessionQuizAnswerRepository>();
        services.AddScoped<IEmployeeCourseSessionQuizAnswerOptionRepository, EmployeeCourseSessionQuizAnswerOptionRepository>();
        services.AddScoped<IEmployeeCourseRepository, EmployeeCourseRepository>();
        services.AddScoped<IEmployeeCourseSessionMediaRepository, EmployeeCourseSessionMediaRepository>();
        services.AddScoped<IEmployeeCourseSessionEmailRepository, EmployeeCourseSessionEmailRepository>();
        services.AddScoped<IPageRepository, PageRepository>();
        services.AddScoped<EmployeeCertificateGenerator>();

        services.AddScoped<ICapaRootCauseMethodologyRepository, CapaRootCauseMethodologyRepository>();
        services.AddScoped<ICapaRootCauseRepository, CapaRootCauseRepository>();
        services.AddScoped<ICapaActionRepository, CapaActionRepository>();
        services.AddScoped<ICapaRequestRepository, CapaRequestRepository>();
        services.AddScoped<ICapaAttachmentRepository, CapaAttachmentRepository>();
        services.AddScoped<ICapaAttachmentChunkRepository, CapaAttachmentChunkRepository>();
        services.AddScoped<ICapaReviewRepository, CapaReviewRepository>();


        services.AddScoped<IDepartmentRepository, DepartmentRepository>();
        services.AddScoped<INonConformanceResponseTypeRepository, NonConformanceResponseTypeRepository>();
        services.AddScoped<IAuditTemplateRepository, AuditTemplateRepository>();
        services.AddScoped<IAuditTemplateQuestionRepository, AuditTemplateQuestionRepository>();
        services.AddScoped<IAuditRepository, AuditRepository>();
        services.AddScoped<INonConformanceRepository, NonConformanceRepository>();
        services.AddScoped<INonConformanceResponseRepository, NonConformanceResponseRepository>();
        services.AddScoped<INonConformanceRespAttachmentRepository, NonConformanceRespAttachmentRepository>();
        services.AddScoped<INonConformanceResponseAttachmentChunkRepository, NonConformanceResponseAttachmentChunkRepository>();
        services.AddScoped<IAuditResponseRepository, AuditResponseRepository>();
        services.AddScoped<IAuditResponseAttachmentRepository, AuditResponseAttachmentRepository>();
        services.AddScoped<IAuditResponseAttachmentChunkRepository, AuditResponseAttachmentChunkRepository>();
        services.AddScoped<IAuditReviewerRepository, AuditReviewerRepository>();
        services.AddScoped<IAuditReviewCommentRepository, AuditReviewCommentRepository>();

        services.AddScoped<OnlyOfficeTokenService>();
        services.AddScoped<IRiskCategoryRepository, RiskCategoryRepository>();
        services.AddScoped<IRiskRepository, RiskRepository>();
        services.AddScoped<IRiskMatrixLevelRepository, RiskMatrixLevelRepository>();
        services.AddScoped<IRiskReviewRepository, RiskReviewRepository>();
        services.AddScoped<IRiskControlRepository, RiskControlRepository>();

        services.AddScoped<IRiskAttachmentRepository, RiskAttachmentRepository>();
        services.AddScoped<IRiskAttachmentChunkRepository, RiskAttachmentChunkRepository>();

        services.AddScoped<ISupplierRepository, SupplierRepository>();
        services.AddScoped<ISupplierAuditRepository, SupplierAuditRepository>();
        services.AddScoped<ISupplierContactRepository, SupplierContactRepository>();
        services.AddScoped<ISupplierPerformanceRepository, SupplierPerformanceRepository>();
        services.AddScoped<ISupplierQualificationRepository, SupplierQualificationRepository>();
        services.AddScoped<ISupplierCertificationRepository, SupplierCertificationRepository>();

        services.AddScoped<IComplaintTypeRepository, ComplaintTypeRepository>();
        services.AddScoped<IComplaintRepository, ComplaintRepository>();
        services.AddScoped<IComplaintCommentRepository, ComplaintCommentRepository>();
        services.AddScoped<IComplaintRootCauseRepository, ComplaintRootCauseRepository>();
        services.AddScoped<IComplaintActionRepository, ComplaintActionRepository>();
        services.AddScoped<IComplaintInvestigationRepository, ComplaintInvestigationRepository>();

        services.AddScoped<IAuditResponseLogRepository, AuditResponseLogRepository>();
        services.AddScoped<INonConformanceLogRepository, NonConformanceLogRepository>();
        services.AddScoped<IComplaintLogRepository, ComplaintLogRepository>();
        services.AddScoped<IRiskLogRepository, RiskLogRepository>();
        services.AddScoped<ICapaRequestLogRepository, CapaRequestLogRepository>();
        services.AddScoped<IComplaintAttchmentRepository, ComplaintAttchmentRepository>();
        services.AddScoped<IComplaintAttachmentChunkRepository, ComplaintAttachmentChunkRepository>();
        services.AddScoped<IModuleRepository, ModuleRepository>();

        services.AddScoped<IArchiveRetentionRepository, ArchiveRetentionRepository>();
    }
}
