﻿using SixLabors.ImageSharp;
using SixLabors.ImageSharp.Processing;
using System;
using System.IO;
using System.Linq;

namespace QualityManagement.API.Helpers;

/// <summary>
/// ImageResize is a static class that provides methods for resizing and saving images.
/// </summary>
public static class ImageResize
{
    /// <summary>
    /// Method to resize an image based on the provided ImageInfo object and save it to the specified path.
    /// </summary>
    /// <param name="imageInfo"></param>
    /// <param name="pathToSave"></param>
    public static void resizeImage(Data.ImageInfo imageInfo, string pathToSave)
    {
        string imageData = imageInfo.Src.Split(',').LastOrDefault();
        byte[] bytes = Convert.FromBase64String(imageData);
        using (MemoryStream ms = new MemoryStream(bytes))
        {

            using (Image image = Image.Load(ms))
            {
                // Resize the image in place and return it for chaining.
                // 'x' signifies the current image processing context.
                image.Mutate(x => x.Resize(imageInfo.Width, imageInfo.Height));

                // The library automatically picks an encoder based on the file extension then
                // encodes and write the data to disk.
                // You can optionally set the encoder to choose.
                image.Save(pathToSave);
            }
        }
    }
    /// <summary>
    /// Method to save an image without resizing it.
    /// </summary>
    /// <param name="imageSoruce"></param>
    /// <param name="pathToSave"></param>
    public static void customImageWithOutResize(string imageSoruce, string pathToSave)
    {
        string imageData = imageSoruce.Split(',').LastOrDefault();
        byte[] bytes = Convert.FromBase64String(imageData);
        using (MemoryStream ms = new MemoryStream(bytes))
        {

            using (Image image = Image.Load(ms))
            {
                // Resize the image in place and return it for chaining.
                // 'x' signifies the current image processing context.
                image.Mutate(x => x.Resize(200, 200));
                // The library automatically picks an encoder based on the file extension then
                // encodes and write the data to disk.
                // You can optionally set the encoder to choose.
                image.Save(pathToSave);
            }
        }
    }
    /// <summary>
    /// method to save an image without resizing it.
    /// </summary>
    /// <param name="imageSoruce"></param>
    /// <param name="pathToSave"></param>
    public static void precriptionImageWithOutResize(string imageSoruce, string pathToSave)
    {
        string imageData = imageSoruce.Split(',').LastOrDefault();
        byte[] bytes = Convert.FromBase64String(imageData);
        using (MemoryStream ms = new MemoryStream(bytes))
        {

            using (Image image = Image.Load(ms))
            {
                // Resize the image in place and return it for chaining.
                // 'x' signifies the current image processing context.
                //image.Mutate(x => x.Resize(200, 200));
                // The library automatically picks an encoder based on the file extension then
                // encodes and write the data to disk.
                // You can optionally set the encoder to choose.
                image.Save(pathToSave);
            }
        }
    }
}
