﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// ActionProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class ActionProfile : Profile
{
    /// <summary>
    /// Action related entities and DTOs.
    /// </summary>
    public ActionProfile()
    {
        CreateMap<Action, ActionDto>().ReverseMap();
        CreateMap<AddActionCommand, Action>();
        CreateMap<UpdateActionCommand, Action>();
    }
}
