﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// AllowFileExtensionProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class AllowFileExtensionProfile : Profile
{
    /// <summary>
    /// allow file extension related entities and DTOs.
    /// </summary>
    public AllowFileExtensionProfile()
    {
        CreateMap<AllowFileExtension, AllowFileExtensionDto>().ReverseMap();
        CreateMap<AddAllowFileExtensionCommand, AllowFileExtension>();
        CreateMap<UpdateAllowFileExtensionCommand, AllowFileExtension>();
    }
}
