﻿using AutoMapper;
using QualityManagement.Data.Dto;
using System.Security.Claims;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// App ClaimProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class AppClaimProfile : Profile
{
    /// <summary>
    /// app claim related entities and DTOs.
    /// </summary>
    public AppClaimProfile()
    {
        CreateMap<AppClaimDto, Claim>()
           .ForMember(dest => dest.Type, opt => opt.MapFrom(src => src.ClaimType))
           .ForMember(dest => dest.Value, opt => opt.MapFrom(src => src.ClaimValue))
           .ReverseMap();


    }
}