﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
///  AuditReponseProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class AuditResponseProfile : Profile
{
    public AuditResponseProfile()
    {
        CreateMap<AddAuditResponseCommand, AuditResponse>();
        CreateMap<AuditResponse, AuditResponseDto>();
        CreateMap<AuditResponseAttachment, AuditResponseAttachmentDto>().ReverseMap();
        CreateMap<SaveAuditResponseAttachmentCommand, AuditResponseAttachment>();
        CreateMap<UpdateAuditResponseCommand, AuditResponse>();
        CreateMap<AuditResponseAttachmentChunk, AuditResponseAttachmentChunkDto>();
        CreateMap<AuditResponse, AuditResponseLog>()
           .ForMember(dest => dest.AuditId, opt => opt.MapFrom(src => src.Id));
    }
}