﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// AuditTemplateProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class AuditTemplateProfile : Profile
{
    /// <summary>
    /// Audit template related entities and DTOs.
    /// </summary>
    public AuditTemplateProfile()
    {
        CreateMap<AddAuditTemplateCommand, AuditTemplate>().ReverseMap();
        CreateMap<AuditTemplateQuestionDto, AuditTemplateQuestion>().ReverseMap();
        CreateMap<QuestionOptionDto, QuestionOption>().ReverseMap();
        CreateMap<AuditTemplate, AuditTemplateDto>();
       CreateMap<UpdateAuditTemplateCommand, AuditTemplate>();
    }
}
