﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;
using System;

namespace QualityManagement.API.Helpers.Mapping
{
    /// <summary>
    /// CapaActionProfile is a mapping profile for AutoMapper that defines the mappings between
    /// </summary>
    public class CapaActionProfile:Profile
    {
        /// <summary>
        /// CapaAction related entities and DTOs
        /// </summary>
        public CapaActionProfile()
        {
            CreateMap<CapaAction, CapaActionDto>()
                .ForMember(des => des.AssignToName, opt => opt.MapFrom(src => src.AssignTo == null ? "" : src.AssignTo.FirstName + " " + src.AssignTo.LastName))
                .ForMember(des => des.CreatedByName, opt => opt.MapFrom(src => src.CreatedByUser == null ? "" : src.CreatedByUser.FirstName + " " + src.CreatedByUser.LastName));
            CreateMap<AddCapaActionCommand, CapaAction>();
            CreateMap<UpdateCapaActionCommand, CapaAction>();
        }
    }
}
