﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// CapaRootCauseMethodologyProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CapaRootCauseMethodologyProfile : Profile
{
    /// <summary>
    /// capa root cause methodology related entities and DTOs.
    /// </summary>
    public CapaRootCauseMethodologyProfile()
    {
        CreateMap<AddCapaRootCauseMethodologyCommand, CapaRootCauseMethodology>();
        CreateMap<UpdateCapaRootCauseMethodologyCommand, CapaRootCauseMethodology>();
        CreateMap<CapaRootCauseMethodologyDto, CapaRootCauseMethodology>().ReverseMap();
    }
}
