﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    /// <summary>
    /// CapaRootCauseProfile  is a mapping profile for AutoMapper that defines the mappings between
    /// </summary>
    public class CapaRootCauseProfile : Profile
    {
        /// <summary>
        /// CapaRootCause Related Entities And DTOs
        /// </summary>
        public CapaRootCauseProfile()
        {
            CreateMap<AddCapaRootCauseCommand, CapaRootCause>();
            CreateMap<UpdateCapaRootCauseCommand, CapaRootCause>();
            CreateMap<CapaRootCause, CapaRootCauseDto>()
            .ForMember(des=>des.CreatedByName,opt=>opt.MapFrom(src=>src.CreatedBy == null ? "" :src.CreatedBy.FirstName + " " +  src.CreatedBy.LastName));
              
        }
    }
}
