﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// category permission related entities and DTOs.
/// </summary>
public class CategoryPermission : Profile
{
    /// <summary>
    /// CategoryPermissionProfile is a mapping profile for AutoMapper that defines the mappings between
    /// </summary>
    public CategoryPermission()
    {
        CreateMap<CategoryUserPermission, CategoryUserPermissionDto>().ReverseMap();
        CreateMap<CategoryRolePermission, CategoryRolePermissionDto>().ReverseMap();
        CreateMap<CategoryUserPermission, CategoryPermissionDto>().ReverseMap();
        CreateMap<CategoryRolePermission, CategoryPermissionDto>().ReverseMap();
    }
}
