﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// category profile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CategoryProfile : Profile
{
    /// <summary>
    /// category related entities and DTOs.
    /// </summary>
    public CategoryProfile()
    {
        CreateMap<Category, CategoryDto>().ReverseMap();
        CreateMap<AddCategoryCommand, Category>().ReverseMap();
        CreateMap<UpdateCategoryCommand, Category>().ReverseMap();
        CreateMap<AddCategoryAssignToMeCommand, Category>().ReverseMap();
    }
}
