﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// company profile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CompanyProfileProfile : Profile
{
    /// <summary>
    /// CompanyProfile related entities and DTOs.
    /// </summary>
    public CompanyProfileProfile()
    {
        CreateMap<CompanyProfile, CompanyProfileDto>().ReverseMap();
        CreateMap<UpdateCompanyProfileCommand, CompanyProfile>();
    }
}
