﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    /// <summary>
    /// 
    /// </summary>
    public class ComplaintCommentProfile:Profile
    {
        /// <summary>
        /// 
        /// </summary>
        public ComplaintCommentProfile()
        {
            CreateMap<AddComplaintCommentCommand, ComplaintComment>();
            CreateMap<ComplaintComment, ComplaintCommentDto>()
                .ForMember(dest=>dest.CommentedByName,opt=>opt
                .MapFrom(src=>src.CommentedBy != null ? src.CommentedBy.FirstName + " " + src.CommentedBy.LastName : " "));
        }
    }
}
