﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// CourseProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CourseProfile : Profile
{
    /// <summary>
    /// Course related entities and DTOs.
    /// </summary>
    public CourseProfile()
    {
        CreateMap<Course, CourseDto>().ReverseMap();
        CreateMap<AddCourseCommand, Course>();
        CreateMap<UpdateCourseCommand, Course>();
    }
}