﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// course session profile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CourseSessionProfile : Profile
{
    /// <summary>
    /// course session related entities and DTOs.
    /// </summary>
    public CourseSessionProfile()
    {
        CreateMap<CourseSession, CourseSessionDto>().ReverseMap();
        CreateMap<AddCourseSessionCommand, CourseSession>();
        CreateMap<UpdateCourseSessionCommand, CourseSession>();
    }
}
