﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// Course Session Quiz Profile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CourseSessionQuizProfile : Profile
{
    /// <summary>
    /// CouseSessionQuiz related entities and DTOs.
    /// </summary>
    public CourseSessionQuizProfile()
    {
        CreateMap<CourseSessionQuiz, CourseSessionQuizDto>().ReverseMap();
        CreateMap<QuizQuestion, QuizQuestionDto>().ReverseMap();
        CreateMap<QuizQuestionOption, QuizQuestionOptionDto>().ReverseMap();
        CreateMap<CreateQuizQuestionCommand, QuizQuestion>();
    }
}