﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// DocumentAuditTrailProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentAuditTrailProfile : Profile
{
    /// <summary>
    /// DocumentAuditTrail related entities and DTOs.
    /// </summary>
    public DocumentAuditTrailProfile()
    {
        CreateMap<DocumentAuditTrailDto, DocumentAuditTrail>().ReverseMap();
        CreateMap<AddDocumentAuditTrailCommand, DocumentAuditTrail>();
    }
}
