﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// DocumentPermission is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentPermission : Profile
{
    /// <summary>
    /// DocumentPermission related entities and DTOs.
    /// </summary>
    public DocumentPermission()
    {
        CreateMap<DocumentUserPermission, DocumentUserPermissionDto>().ReverseMap();
        CreateMap<DocumentRolePermission, DocumentRolePermissionDto>().ReverseMap();
        CreateMap<DocumentUserPermission, DocumentPermissionDto>().ReverseMap();
        CreateMap<DocumentRolePermission, DocumentPermissionDto>().ReverseMap();
    }
}
