﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// DocumentProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentProfile : Profile
{
    /// <summary>
    /// Document related entities and DTOs.
    /// </summary>
    public DocumentProfile()
    {
        CreateMap<Document, DocumentDto>().ReverseMap();
        CreateMap<AddDocumentCommand, Document>();
        CreateMap<UpdateDocumentCommand, Document>();
        CreateMap<AddDocumentToMeCommand, Document>();
        CreateMap<DocumentComment, DocumentCommentDto>().ReverseMap();
        CreateMap<DocumentShareableLink, DocumentShareableLinkDto>().ReverseMap();
        CreateMap<CreateDocumentShareableLinkCommand, DocumentShareableLink>();
        CreateMap<AddDocumentCommentCommand, DocumentComment>();

        CreateMap<DocumentVersion, DocumentVersionDto>().ReverseMap();
        CreateMap<DocumentMetaData, DocumentMetaDataDto>().ReverseMap();
        CreateMap<UploadNewDocumentVersionCommand, DocumentVersion>();
        CreateMap<DocumentChunkDto, DocumentChunk>().ReverseMap();
        CreateMap<AddDocumentChunkCommand, Document>();
        CreateMap<DocumentMetaTagDto, DocumentMetaTag>().ReverseMap();
        CreateMap<AddDocumentChunkWindowSharedCommand, Document>();
        CreateMap<AddDocumentWindowSharedCommand, Document>();
    }
}
