﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// EmailProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class EmailProfile : Profile
{
    /// <summary>
    /// EmailProfile related entities and DTOs.
    /// </summary>
    public EmailProfile()
    {
        CreateMap<EmailSMTPSetting, EmailSMTPSettingDto>().ReverseMap();
        CreateMap<EmailSMTPSetting, AddEmailSMTPSettingCommand>().ReverseMap();
        CreateMap<EmailSMTPSetting, UpdateEmailSMTPSettingCommand>().ReverseMap();
    }
}
