﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// FileRequestProfile class for mapping between FileRequest and FileRequestDto.
/// </summary>
public class FileRequestProfile : Profile
{
    /// <summary>
    /// FileRequestProfile constructor for initializing the mapping configuration.
    /// </summary>
    public FileRequestProfile()
    {
        CreateMap<FileRequest, FileRequestDto>().ReverseMap();
        CreateMap<AddFileRequestCommand, FileRequest>();
        CreateMap<UpdateFileRequestCommand, FileRequest>();
    }
}
