﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// MatTableSettingProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class MatTableSettingProfile : Profile
{
    /// <summary>
    /// mattable setting related entities and DTOs.
    /// </summary>
    public MatTableSettingProfile()
    {
        CreateMap<MatTableSetting, MatTableSettingDto>().ReverseMap();
        CreateMap<AddOrUpdateTableSettingCommand, MatTableSetting>().ReverseMap();

    }
}
