﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;
using System;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// NonConformanceProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class NonConformanceProfile : Profile
{

    /// <summary>
    /// NonConformance related entities and DTOs.
    /// 
    /// </summary>
    public NonConformanceProfile()
    {

        CreateMap<NonConformance, NonConformanceDto>()
       .ForMember(dest => dest.ReportedByName, opt => opt.MapFrom(src => src.ReportedBy != null ?  src.ReportedBy.FirstName + " " + src.ReportedBy.LastName : ""))
       .ForMember(dest => dest.DepartmentName, opt => opt.MapFrom(src => src.Department != null ? src.Department.Name : ""))
       .ForMember(dest => dest.AuditName, opt => opt.MapFrom(src => src.Audit != null ? src.Audit.Title : ""));
        CreateMap<AddNonConformanceCommand, NonConformance>();
        CreateMap<NonConformanceRespAttachment, NonConformanceRespAttachmentDataDto>();
        CreateMap<UpdateNonConformanceCommand, NonConformance>();
        CreateMap<NonConformance, NonConformanceLog>()
            .ForMember(c => c.NonConformanceId, opt => opt.MapFrom(src => src.Id));

    }
}
