﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// PageProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class PageProfile : Profile
{
    /// <summary>
    /// PageProfile constructor for initializing the mapping configuration.
    /// </summary>
    public PageProfile()
    {
        CreateMap<Page, PageDto>().ReverseMap();
        CreateMap<AddPageCommand, Page>();
        CreateMap<UpdatePageCommand, Page>();
    }
}
