﻿using AutoMapper;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR.RiskManagement;

namespace QualityManagement.API.Helpers.Mapping
{
    public class RiskControlProfile:Profile
    {
        public RiskControlProfile()
        {
            CreateMap<AddRiskControlCommand, RiskControl>();
            CreateMap<UpdateRiskControlCommand, RiskControl>();
            CreateMap<RiskControl, RiskControlDto>()
                .ForMember(dest=>dest.ResponsibleByName,opt=>opt
                .MapFrom(src=>src.ResponsibleBy != null ? src.ResponsibleBy.FirstName + " "+ src.ResponsibleBy.LastName : ""  ));
        }
    }
}
