﻿using AutoMapper;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;
using QualityManagement.MediatR.RiskManagement;
using System;

namespace QualityManagement.API.Helpers.Mapping
{
    public class RiskProfile:Profile
    {
        public RiskProfile()
        {
            CreateMap<Risk, RiskDto>()
                .ForMember(dest=>dest.AssignedToName,opt=>opt
                .MapFrom(src=>src.AssignedTo != null ? src.AssignedTo.FirstName + " " + src.AssignedTo.LastName:""))
                 .ForMember(dest => dest.RiskCategoryName, opt => opt
                .MapFrom(src => src.RiskCategory != null ? src.RiskCategory.Name: ""))
                 .ForMember(dest => dest.CreatedByName, opt => opt
                .MapFrom(src => src.CreatedUser != null ? src.CreatedUser.FirstName + " " + src.CreatedUser.LastName : ""))
                ;
            CreateMap<AddRiskCommand, Risk>();
            CreateMap<UpdateRiskCommand, Risk>();
            CreateMap<Risk, RiskLog>()
                .ForMember(dest => dest.RiskId, opt => opt.MapFrom(src => src.Id));
            
        }
    }
}
