﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// RoleProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class RoleProfile : Profile
{
    /// <summary>
    /// RoleProfile constructor for initializing the mapping configuration.
    /// </summary>
    public RoleProfile()
    {
        CreateMap<RoleClaim, RoleClaimDto>().ReverseMap();
        CreateMap<Role, RoleDto>().ReverseMap();
        CreateMap<AddRoleCommand, Role>();
        CreateMap<UpdateRoleCommand, Role>();
    }
}
