﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// StorageSettingProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class StorageSettingProfile : Profile
{
    /// <summary>
    /// StorageSettingProfile constructor for initializing the mapping configuration.
    /// </summary>
    public StorageSettingProfile()
    {
        CreateMap<StorageSetting, StorageSettingDto<string>>().ReverseMap();
        CreateMap<AddStorageSettingCommand, StorageSetting>();
        CreateMap<UpdateStorageSettingCommand, StorageSetting>();
    }
}
