﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

public class SupplierAuditProfile : Profile
{
    public SupplierAuditProfile()
    {
        CreateMap<SupplierAudit, SupplierAuditDto>()
            .ForMember(dest => dest.AuditorName, opt => opt.MapFrom(src => src.Auditor == null ? "" : src.Auditor.FirstName + " " + src.Auditor.LastName)).ReverseMap();
        CreateMap<AddSupplierAuditCommand, SupplierAudit>();
    }
}
