﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

public class SupplierPerformanceProfile : Profile
{
    public SupplierPerformanceProfile()
    {
        CreateMap<AddSupplierPerformanceCommand, SupplierPerformance>();
        CreateMap<SupplierPerformance, SupplierPerformanceDto>()
            .ForMember(dest => dest.EvaluatedByName, opt => opt.MapFrom(src => src.EvaluatedBy == null ? "" : src.EvaluatedBy.FirstName + " " + src.EvaluatedBy.LastName)).ReverseMap();
    }
}
