﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

public class SupplierQualificationProfile : Profile
{
    public SupplierQualificationProfile()
    {
        CreateMap<SupplierQualification, SupplierQualificationDto>()
            .ForMember(dest => dest.QualifiedByName, opt => opt.MapFrom(src => src.QualifiedBy == null ? "" : src.QualifiedBy.FirstName + " " + src.QualifiedBy.LastName))
            .ReverseMap();
        CreateMap<AddSupplierQualificationCommand, SupplierQualification>();
    }
}
