﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// UserProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class UserProfile : Profile
{
    /// <summary>
    /// UserProfile constructor for initializing the mapping configuration.
    /// </summary>
    public UserProfile()
    {
        CreateMap<UserClaimDto, UserClaim>().ReverseMap();
        CreateMap<UserRoleDto, UserRole>().ReverseMap();
        CreateMap<User, UserDto>().ReverseMap();
        CreateMap<AddUserCommand, User>();
        CreateMap<ResetPasswordCommand, UserDto>();
    }
}
