﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// WorkflowInstanceProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class WorkflowInstanceProfile : Profile
{
    /// <summary>
    /// WorkflowInstanceProfile constructor for initializing the mapping configuration.
    /// </summary>
    public WorkflowInstanceProfile()
    {
        CreateMap<WorkflowInstanceDto, WorkflowInstance>().ReverseMap();
        CreateMap<AddWorkflowInstanceCommand, WorkflowInstance>();
        CreateMap<UpdateWorkflowInstanceCommand, WorkflowInstance>();
    }
}