﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// WorkflowProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class WorkflowProfile : Profile
{
    /// <summary>
    /// WorkflowProfile constructor for initializing the mapping configuration.
    /// </summary>
    public WorkflowProfile()
    {
        CreateMap<WorkflowDto, Workflow>().ReverseMap();
        CreateMap<AddWorkflowCommand, Workflow>();
        CreateMap<UpdateWorkflowCommand, Workflow>();
    }
}
