﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// WorkflowStepProfile class for mapping between WorkflowStep and WorkflowStepDto.
/// </summary>
public class WorkflowStepProfile : Profile
{
    /// <summary>
    /// WorkflowStepProfile constructor for initializing the mapping configuration.
    /// </summary>
    public WorkflowStepProfile()
    {
        CreateMap<WorkflowStepDto, WorkflowStep>().ReverseMap();
        CreateMap<WorkflowStepDataDto, WorkflowStep>().ReverseMap();
        CreateMap<AddWorkflowStepCommand, WorkflowStep>();
        CreateMap<UpdateWorkflowStepCommand, WorkflowStep>();
    }
}