﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// WorkflowTransitionProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class WorkflowTransitionProfile : Profile
{
    /// <summary>
    /// WorkflowTransitionProfile constructor for initializing the mapping configuration.
    /// </summary>
    public WorkflowTransitionProfile()
    {
        CreateMap<WorkflowTransitionDto, WorkflowTransition>().ReverseMap();
        CreateMap<WorkflowTransitionDataDto, WorkflowTransition>().ReverseMap();
        CreateMap<AddWorkflowTransitionCommand, WorkflowTransition>();
        CreateMap<UpdateWorkflowTransitionCommand, WorkflowTransition>();
        CreateMap<WorkflowTransitionRoleDto, WorkflowTransitionRole>().ReverseMap();
        CreateMap<WorkflowTransitionUserDto, WorkflowTransitionUser>().ReverseMap();
    }
}
