﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using System;

namespace QualityManagement.Api.Helpers;

/// <summary>
/// unprocessable entity object result is a custom implementation of ObjectResult that represents an HTTP 422 Unprocessable Entity response.
/// </summary>
public class UnprocessableEntityObjectResult : ObjectResult
{
    /// <summary>
    /// constructor for UnprocessableEntityObjectResult that takes a ModelStateDictionary as a parameter.
    /// </summary>
    /// <param name="modelState"></param>
    /// <exception cref="ArgumentNullException"></exception>
    public UnprocessableEntityObjectResult(ModelStateDictionary modelState)
        : base(new SerializableError(modelState))
    {
        if (modelState == null)
        {
            throw new ArgumentNullException(nameof(modelState));
        }
        StatusCode = 422;
    }
}
/// <summary>
/// UnAuthorizedEntityObjectResult is a custom implementation of ObjectResult that represents an HTTP 403 Forbidden response.
/// </summary>
public class UnAuthorizedEntityObjectResult : ObjectResult
{
    /// <summary>
    /// UnAuthorizedEntityObjectResult constructor that takes a ModelStateDictionary as a parameter.
    /// </summary>
    /// <param name="modelState"></param>
    /// <exception cref="ArgumentNullException"></exception>
    public UnAuthorizedEntityObjectResult(ModelStateDictionary modelState)
        : base(new SerializableError(modelState))
    {
        if (modelState == null)
        {
            throw new ArgumentNullException(nameof(modelState));
        }
        StatusCode = 403;
    }
}
/// <summary>
/// UnAuthenticationEntityObjectResult is a custom implementation of ObjectResult that represents an HTTP 401 Unauthorized response.
/// </summary>
public class UnAuthenticationEntityObjectResult : ObjectResult
{
    /// <summary>
    /// A constructor for UnAuthenticationEntityObjectResult that takes a ModelStateDictionary as a parameter.
    /// </summary>
    /// <param name="modelState"></param>
    /// <exception cref="ArgumentNullException"></exception>
    public UnAuthenticationEntityObjectResult(ModelStateDictionary modelState)
        : base(new SerializableError(modelState))
    {
        if (modelState == null)
        {
            throw new ArgumentNullException(nameof(modelState));
        }
        StatusCode = 401;
    }
}

/// <summary>
/// BadRequestEntityObjectResult is a custom implementation of ObjectResult that represents an HTTP 500 Internal Server Error response.
/// </summary>
public class BadRequestEntityObjectResult : ObjectResult
{
    /// <summary>
    /// BadRequestEntityObjectResult constructor that takes a ModelStateDictionary as a parameter.
    /// </summary>
    /// <param name="modelState"></param>
    /// <exception cref="ArgumentNullException"></exception>
    public BadRequestEntityObjectResult(ModelStateDictionary modelState)
    : base(new SerializableError(modelState))
    {
        if (modelState == null)
        {
            throw new ArgumentNullException(nameof(modelState));
        }
        StatusCode = 500;
    }
}

/// <summary>
/// AlreadyExistEntityObjectResult is a custom implementation of ObjectResult that represents an HTTP 409 Conflict response.
/// </summary>
public class AlreadyExistEntityObjectResult : ObjectResult
{
    /// <summary>
    /// A constructor for AlreadyExistEntityObjectResult that takes a message as a parameter.
    /// </summary>
    /// <param name="message"></param>
    /// <exception cref="ArgumentNullException"></exception>
    public AlreadyExistEntityObjectResult(String message)
        : base(message)
    {
        if (message == null)
        {
            throw new ArgumentNullException(nameof(message));
        }
        StatusCode = 409;
    }
}


