﻿using System.Threading;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;

namespace QualityManagement.Common.UnitOfWork;

public interface IUnitOfWork<TContext>
    where TContext : DbContext
{
    int Save();
    Task<int> SaveAsync(CancellationToken cancellationToken = default);
    TContext Context { get; }

    bool Migration();
}
