﻿using QualityManagement.Data.Entities;
using QualityManagement.Data.Entities.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.Data.Dto.RiskManagement
{
    public class RiskLogDto
    {
        public Guid Id { get; set; }
        public Guid RiskId { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public Guid RiskCategoryId { get; set; }
        public string RiskCategoryName { get; set; }
        public int Likelihood { get; set; }
        public int Severity { get; set; }
        public int RiskScore { get; set; }
        public string RiskLevel { get; set; }
        public LogStatus LogStatus { get; set; }
        public RiskStatusEnum Status { get; set; }
        public Guid AssignedToId { get; set; }
        public string AssignedToName { get; set; }
        public Guid CreatedBy { get; set; }
        public DateTime CreatedDate { get; set; }
        public string CreatedByName { get; set; }

        public ICollection<RiskReviewDto> RiskReviews { get; set; } = new List<RiskReviewDto>();
        public ICollection<RiskControl> RiskControls { get; set; } = new List<RiskControl>();
        public ICollection<RiskAttachment> RiskAttachments { get; set; } = new List<RiskAttachment>();
    }
}
