﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditResponseAttachment
{
    public Guid Id { get; set; }
    public string FilePath { get; set; }
    public string FileName { get; set; }
    public long FileSize { get; set; }
    public string Extension { get; set; }
    public string Description { get; set; }
    public Guid AuditResponseId { get; set; }
    [ForeignKey("AuditResponseId")]
    public AuditResponse AuditResponse { get; set; }
    public bool IsChunk { get; set; }
    public Guid? StorageSettingId { get; set; }
    [ForeignKey("StorageSettingId")]
    public StorageSetting StorageSetting { get; set; }
    public byte[] Key { get; set; } = null;
    public byte[] IV { get; set; } = null;
    public StorageType StorageType { get; set; }
    public bool IsAllChunkUploaded { get; set; }
    public bool IsDeleted { get; set; }
    public Guid ModifiedBy { get; set; }
    public int TotalChunk { get; set; }
    public ICollection<AuditResponseAttachmentChunk> AuditResponseAttachmentChunks { get; set; } = new List<AuditResponseAttachmentChunk>();
}